%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%   Computation of matrices for a direct FD method


function[A,C]= mACfd(Vstart,N2)

C = zeros(N2^2,1);
for i=1:N2
    for j = 1:N2
        k = (i-1)*N2 + j;
       
        A(k,k)= 1;
       
        if (Vstart(i,j)==0)
            A(k,k-N2)= -1/4; %up
            A(k,k+N2)= -1/4; %down
            A(k,k+1)=-1/4;   %right
            A(k,k-1)= -1/4;  %left
        else C(k)=Vstart(i,j);
        end;
       
    end;
end;